/* $Id: trigger.c,v 1.3 1998/07/20 23:37:13 ericb Exp $ */
/* Copyright (C) 1997 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Keith Bayern */

/***************************************************************************

This is a variation on minimum.c to show a triggered measurement.

***************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "hpe1432.h"

#define BLOCK_SIZE 16

void main()
{
ViSession	session;
ViInt32		channels[10];
ViInt32		gid;
ViReal64	data[BLOCK_SIZE];
char		st[100];
ViInt32		actualCount;
ViInt32		i;
ViStatus	vierr;

    /* initialize instrument  This code ASSUMES hpe1432 at address 8 */
    vierr=hpe1432_init("VXI0::8::INSTR",0,1,&session);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);	    
        exit(0);
    }

    /* make an array of input channel numbers (only one in this simple demo) */
    channels[0]=1;

    vierr=hpe1432_createChannelGroup(session,1,channels,&gid);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    /* set the fifo blocksize */
    vierr=hpe1432_setBlocksize(session,gid,BLOCK_SIZE);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    /* turn off all channel triggering */
    /* (some channels could have been left on from previous setups) */
    vierr=hpe1432_setTriggerChannel(session,gid,HPE1432_CHANNEL_OFF);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    /* Turn on channel one for triggering. */
    /* Any number of channels, sources, tachs could be the source of the */
    /* trigger event, but for this example, only the first channel 
    /* is allowed to trigger */
    vierr=hpe1432_setTriggerChannel(session,channels[0],HPE1432_CHANNEL_ON);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    /* Set to trigger on positive slope at the zero crossing.       */
    /* NOTE that to trigger at zero on negative crossing,           */
    /* both upper and lower levels would need to be changed         */
    /* since the first level crossed merely prepares for triggering */
    /* and the second level crossed causes the trigger.             */
    /* Try to keep the difference between levels at 10%             */
    vierr=hpe1432_setTriggerLevel(session,channels[0],
                                  HPE1432_TRIGGER_LEVEL_LOWER,
                                  -10);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    vierr=hpe1432_setTriggerLevel(session,channels[0],
                                  HPE1432_TRIGGER_LEVEL_UPPER,
                                  0);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    vierr=hpe1432_setTriggerSlope(session,channels[0],
                                  HPE1432_TRIGGER_SLOPE_POS);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }


    

    vierr=hpe1432_setAutoTrigger(session,gid,HPE1432_MANUAL_TRIGGER);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

printf("This demo needs a signal over 1 volt on channel 1 that crosses zero\n");

    /* get some data coming */
    /* this will hang until a signal large enough to trigger is input */
    vierr=hpe1432_initMeasure(session,gid);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    /* wait for the data and then read it */
    vierr=hpe1432_readFloat64Data(session,gid,
                                  HPE1432_TIME_DATA,
                                  data,
                                  BLOCK_SIZE,
                                  &actualCount,
                                  HPE1432_WAIT_FLAG);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    /* print the data */
    for(i=0;i<5;i++)
		printf("%lf\n",data[i]);


    
}





